<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Theme Egg
 * @subpackage Eggnews
 * @since 1.0.0
 */

?>
		</div><!--.teg-container-->
	</div><!-- #content -->

	<footer id="colophon" class="site-footer">
		<?php $parallax_footer = get_theme_mod('parallax_footer_eggnews', '') ?>
		<?php if(!empty($parallax_footer)) { ?>
			<?php       
         /**                 
            * Preload Feature                 
            * @package Theme Egg                 
            * @subpackage eggnews                 
            * @since 1.4.12  
        */?>
        <div class="parallax" style='background-image: url("<?php echo esc_url($parallax_footer); ?>");'>
        	<div class="parallax-content">
        	<?php } ?>
        	<?php get_sidebar( 'footer' ); ?>
        	<?php if($parallax_footer) { ?>
        	</div>
        </div>
    <?php } ?>

			<div id="bottom-footer" class="sub-footer-wrapper clearfix">
				<div class="teg-container">
					<div class="site-info">
							<?php esc_attr_e('&copy;', 'wind'); ?> <?php _e(date('Y')); ?> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
Использование материалов сайта допускается только с указанием обязательной (индексируемой) ссылки на источник. Мнения и взгляды авторов не всегда совпадают с точкой зрения редакции.
						
					</div><!-- .site-info -->
					<nav id="footer-navigation" class="sub-footer-navigation" >
						<?php wp_nav_menu( array( 'theme_location' => 'footer', 'container_class' => 'footer-menu', 'fallback_cb' => false, 'items_wrap' => '<ul>%3$s</ul>' ) ); ?>
					</nav>
				</div>
			</div><!-- .sub-footer-wrapper -->
	</footer><!-- #colophon -->
	<div id="teg-scrollup" class="animated arrow-hide"><i class="fa fa-chevron-up"></i></div>
</div><!-- #page -->
<?php wp_footer(); ?>
</body>
</html>
